import pytest
from fastapi.testclient import TestClient
from server import app

client = TestClient(app)

def test_register_user():
    """Test user registration"""
    response = client.post("/api/auth/register", json={
        "name": "Test User",
        "email": "test@example.com",
        "password": "testpassword",
        "user_type": "reader"
    })
    assert response.status_code == 200
    data = response.json()
    assert "user" in data
    assert data["user"]["email"] == "test@example.com"

def test_login_user():
    """Test user login"""
    # First register
    client.post("/api/auth/register", json={
        "name": "Test User",
        "email": "test2@example.com",
        "password": "testpassword",
        "user_type": "reader"
    })
    
    # Then login
    response = client.post("/api/auth/login", json={
        "email": "test2@example.com",
        "password": "testpassword"
    })
    assert response.status_code == 200
    data = response.json()
    assert "user" in data
    assert data["user"]["email"] == "test2@example.com"

def test_get_landing_content():
    """Test getting landing page content"""
    response = client.get("/api/content/landing-page")
    assert response.status_code == 200
    data = response.json()
    assert "hero_title" in data
    assert "hero_subtitle" in data