#!/bin/bash

# Queens Mountain Cleanup Script
# Run this to remove previous deployments before fresh install

echo "🧹 Cleaning up previous Queens Mountain deployment..."

# Stop and disable services
echo "🛑 Stopping services..."
systemctl stop queens-mountain 2>/dev/null || true
systemctl disable queens-mountain 2>/dev/null || true

# Remove systemd service
rm -f /etc/systemd/system/queens-mountain.service
systemctl daemon-reload

# Remove nginx configuration
rm -f /etc/nginx/sites-enabled/queens-mountain
rm -f /etc/nginx/sites-available/queens-mountain
systemctl restart nginx

# Remove application directory
echo "🗑️ Removing application files..."
rm -rf /var/www/queens-mountain

# Remove uploaded files (be careful with this!)
echo "⚠️ Removing uploaded files..."
rm -rf /var/www/uploads

# Clean up packages (optional - only if you want to remove everything)
# echo "🧹 Removing installed packages..."
# pip uninstall -y fastapi uvicorn motor python-multipart python-jose passlib bcrypt
# npm uninstall -g create-react-app 2>/dev/null || true

# Clean npm cache
npm cache clean --force 2>/dev/null || true

echo "✅ Cleanup complete!"
echo "🎯 Ready for fresh deployment."