#!/bin/bash

# Queens Mountain Deployment Verification Script

echo "🔍 Verifying Queens Mountain deployment..."

# Check if services are running
echo "📊 Checking services..."
systemctl is-active --quiet queens-mountain && echo "✅ Backend service: RUNNING" || echo "❌ Backend service: STOPPED"
systemctl is-active --quiet nginx && echo "✅ Nginx: RUNNING" || echo "❌ Nginx: STOPPED"
systemctl is-active --quiet mongod && echo "✅ MongoDB: RUNNING" || echo "❌ MongoDB: STOPPED"

# Check if ports are listening
echo "🔌 Checking ports..."
netstat -tlnp | grep :8000 && echo "✅ Backend port 8000: LISTENING" || echo "❌ Backend port 8000: NOT LISTENING"
netstat -tlnp | grep :80 && echo "✅ HTTP port 80: LISTENING" || echo "❌ HTTP port 80: NOT LISTENING"

# Check application directory
echo "📁 Checking application directory..."
[ -d "/var/www/queens-mountain" ] && echo "✅ Application directory: EXISTS" || echo "❌ Application directory: MISSING"
[ -f "/var/www/queens-mountain/.env" ] && echo "✅ Environment file: EXISTS" || echo "❌ Environment file: MISSING"
[ -d "/var/www/queens-mountain/frontend/build" ] && echo "✅ Frontend build: EXISTS" || echo "❌ Frontend build: MISSING"

# Check MongoDB connection
echo "🗄️ Checking MongoDB..."
mongosh --eval "db.runCommand('ping')" > /dev/null 2>&1 && echo "✅ MongoDB connection: SUCCESS" || echo "❌ MongoDB connection: FAILED"

# Test backend API
echo "🔗 Testing backend API..."
curl -s -o /dev/null -w "%{http_code}" http://localhost:8000/api/content/landing-page | grep 200 && echo "✅ Backend API: RESPONDING" || echo "❌ Backend API: NOT RESPONDING"

# Test frontend
echo "🌐 Testing frontend..."
curl -s -o /dev/null -w "%{http_code}" http://localhost | grep 200 && echo "✅ Frontend: SERVING" || echo "❌ Frontend: NOT SERVING"

echo "🎯 Verification complete!"
echo "📝 Check the results above and fix any issues before going live."